/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.scaffoldingpower;

import com.lothrazar.scaffoldingpower.ConfigManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RailEvents {
    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos fromUp;
        BlockPos endPos;
        if (!((Boolean)ConfigManager.RAILBUILD.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        Level world = event.getWorld();
        BlockState stateOG = world.m_8055_(pos);
        ItemStack held = event.getItemStack();
        if (this.isRail(held) && this.isRail(stateOG) && (endPos = this.buildRails(player, pos, world, held)) != null && (fromUp = this.buildRails(player, endPos.m_7494_(), world, held)) != null) {
            this.buildRails(player, endPos.m_7495_(), world, held);
        }
    }

    private BlockPos buildRails(Player player, BlockPos pos, Level world, ItemStack held) {
        Direction facing = player.m_6350_();
        BlockPos posCurrent = pos;
        BlockPos previous = pos;
        for (int i = 1; i < (Integer)ConfigManager.RAILSAUTOBUILDRANGE.get(); ++i) {
            previous = posCurrent;
            posCurrent = pos.m_5484_(facing, i);
            BlockState newRail = Block.m_49814_((Item)held.m_41720_()).m_49966_();
            BlockState stateCurrent = world.m_8055_(posCurrent);
            if (this.isRail(stateCurrent)) continue;
            boolean replaceHere = stateCurrent.m_60767_().m_76336_();
            if (replaceHere && newRail.m_60710_((LevelReader)world, posCurrent)) {
                if (!world.m_46597_(posCurrent, newRail)) continue;
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                return null;
            }
            return previous;
        }
        return null;
    }

    private boolean isRail(BlockState block) {
        return block.m_204336_(BlockTags.f_13034_);
    }

    private boolean isRail(ItemStack item) {
        return item.m_204117_(ItemTags.f_13142_);
    }
}

